package game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;


public class PlayingWithCosine {
	
	public static void main(String [] args) {
		
		double temp;
		
		for(int i = 0; i < 100; i++) {
			temp = i * 2.0 * Math.PI / 100.0;
//			System.out.println("input is: " + temp + ", sine: " + Math.sin(temp) + ", cosine: " + Math.cos(temp));
		}
		
		drawRainbow();
		
		
	}
	
	
	public static final double YELLOW_POINT = 0.25;
	public static final double GREEN_POINT = 0.5;
	public static final double BLUE_POINT = 0.75;
	
	public static Color scalarToColor(double scalar) {
		
		if(scalar < 0.0 || scalar > 1.0)
			return null;
		
		int red, green, blue;
		
		if(scalar <= YELLOW_POINT) {
			
			//red, with green going from 0 to 255
			
			red = 255;
			green = (int) (255 * scalar / YELLOW_POINT);
			blue = 0;
			
		} else if(scalar <= GREEN_POINT) {
			
			green = 255;
			blue = 0;
			
			red = (int) (255.0 * (1.0 - (scalar - YELLOW_POINT) / (GREEN_POINT - YELLOW_POINT)));
			
		} else if(scalar <= BLUE_POINT) {
			red = 0;
			
			green = (int) (255.0 * (1.0 - (scalar - GREEN_POINT) / (BLUE_POINT - GREEN_POINT)));
			blue = (int) (255.0 * ((scalar - GREEN_POINT) / (BLUE_POINT - GREEN_POINT)));
		} else {
			green = 0;
			blue = 255;
			
			red = (int) (255.0 * ((scalar - BLUE_POINT) / (1.0 - BLUE_POINT)));
		}
		
		return new Color(red, green, blue);
	}
	
	public static final int RAINBOW_PIXEL_LENGTH = 35;
	//75
	
	public static final int RAINBOW_DIAMETER = 770; //800
	
	public static void drawRainbow() {
		
		JFrame frame = new JFrame();
		
		JPanel panel = new JPanel();
		
		frame.setContentPane(panel);
		
		frame.setMaximumSize(new Dimension(RAINBOW_DIAMETER + 50, RAINBOW_DIAMETER / 2 + 50));
		frame.setMinimumSize(new Dimension(RAINBOW_DIAMETER + 50, RAINBOW_DIAMETER / 2 + 50));
		frame.setPreferredSize(new Dimension(RAINBOW_DIAMETER + 50, RAINBOW_DIAMETER / 2 + 50));
		frame.setVisible(true);
		
		try {
			Thread.sleep(2000L);
		} catch (Throwable t) {}
		
		Image image = panel.createImage(RAINBOW_DIAMETER, RAINBOW_DIAMETER / 2);
		Graphics g = image.getGraphics();
		
		double scalar; 
		
		Color origColor = g.getColor();
		
		g.setColor(Color.white);
		g.fillRect(0, 0, RAINBOW_DIAMETER, RAINBOW_DIAMETER / 2);
		
		for(int x = 0; x < RAINBOW_PIXEL_LENGTH; x++) {
			
			scalar = ((double) x) / ((double) RAINBOW_PIXEL_LENGTH);
			
			g.setColor(scalarToPastelColor(scalar));
			g.fillOval(x, x, RAINBOW_DIAMETER - 2*x, RAINBOW_DIAMETER - 2*x);
			
		}
		
		g.setColor(Color.WHITE);
		g.fillOval(RAINBOW_PIXEL_LENGTH, RAINBOW_PIXEL_LENGTH, RAINBOW_DIAMETER - 2*RAINBOW_PIXEL_LENGTH, RAINBOW_DIAMETER - 2*RAINBOW_PIXEL_LENGTH);
		
		
		ImageIcon icon = new ImageIcon(image);
		
		JLabel label = new JLabel(icon);
		panel.add(label);
		
		panel.repaint();
		
	}
	
	
	
	

	public static Color scalarToPastelColor(double scalar) {
		
		if(scalar < 0.0 || scalar > 1.0)
			return null;
		
		int red, green, blue;
		
		if(scalar <= YELLOW_POINT) {
			
			//red, with green going from 0 to 255
			
			red = 255;
			green = (int) (155 * scalar / YELLOW_POINT) + 100;
			blue = 100;
			
		} else if(scalar <= GREEN_POINT) {
			
			green = 255;
			blue = 100;
			
			red = (int) (155.0 * (1.0 - (scalar - YELLOW_POINT) / (GREEN_POINT - YELLOW_POINT))) + 100;
			
		} else if(scalar <= BLUE_POINT) {
			red = 100;
			
			green = (int) (155.0 * (1.0 - (scalar - GREEN_POINT) / (BLUE_POINT - GREEN_POINT))) + 100;
			blue = (int) (155.0 * ((scalar - GREEN_POINT) / (BLUE_POINT - GREEN_POINT))) + 100;
		} else {
			green = 100;
			blue = 255;
			
			red = (int) (155.0 * ((scalar - BLUE_POINT) / (1.0 - BLUE_POINT))) + 100;
		}
		
		return new Color(red, green, blue);
	}
	
	
}
